<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of LeaveRequestListFactory
 *
 * @author Sameera
 */
class LeaveRequestListFactory extends LeaveRequestFactory  implements IteratorAggregate {
    //put your code here
    
    	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
            
            
            
            
		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}
        
        
        
      function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$this->rs = $this->getCache($id);
		if ( $this->rs === FALSE ) {
			$ph = array(
						'id' => $id,
						);

			$query = '
						select 	*
						from	'. $this->getTable() .'
						where	id = ?
							AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		}

		return $this;
	}
        
        
        
       function getByIdAndCompanyId($id, $company_id=1, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
                                        'company_id'=>$company_id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ? 
                                         company_id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}
        
        
        function getByUserIdAndCompanyId($user_id, $company_id=1, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		$ph = array(
					'user_id' => $user_id,
                                        'company_id'=>$company_id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	user_id = ?  
                                         AND company_id = ? 
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}
        
        
        
    function getByCoveredEmployeeId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		
		
			$ph = array(
						'covered_by' => $id,
						);

			$query = '
						select 	*
						from	'. $this->getTable() .'
						where covered_by = ? 
                                                AND is_covered_approved = 1 
                                                AND status = 10 
						AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		

		return $this;
	}
        
        
        
        
            function getBySupervisorEmployeeId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		
		
			$ph = array(
						'supervisor_id' => $id,
						);

			$query = '
						select 	*
						from	'. $this->getTable() .'
						where supervisor_id = ? 
                                                AND is_covered_approved = 1 
                                                AND is_supervisor_approved = 0 
                                                AND status = 10 
						AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		

		return $this;
	}
        
        
        
        
        
        function getByHrEmployeeId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		
		/*
			$ph = array(
						'supervisor_id' => $id,
						);
*/
			$query = '
						select 	*
						from	'. $this->getTable() .'
						where  is_covered_approved = 1 
                                                AND is_supervisor_approved = 1 
                                                AND is_hr_approved = 0 
                                                AND status = 10 
						AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		

		return $this;
	}
        
        
        function checkUserHasLeaveForDay($user_id,$leave_date, $where = NULL, $order = NULL)
        {
                if ( $leave_date == '') {
			return FALSE;
		}
                
                if ( $user_id == '') {
			return FALSE;
		}
                
                
                   $ph = array(               
						'user_id' => $user_id,
						);

			$query = "select * from ". $this->getTable() ." as a "
                                . " where '".$leave_date."' between a.leave_from and a.leave_to "
                                . " and a.user_id = ? "
                                . " and a.is_covered_approved = 1 "
                                . " and a.is_supervisor_approved = 1 "
                                . " and a.is_hr_approved = 1 "
                                . " and a.deleted = 0";
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			//$this->saveCache($this->rs,$id);
		

		return $this;
        }
        
}
