<?php
/*********************************************************************************
 * Evolve is a Payroll and Time Management program developed by
 * Evolve Technology PVT LTD.
 *
 ********************************************************************************/
/*
 * $Revision: 5459 $
 * $Id: EditCompanyDeduction.php 5459 2011-11-04 21:40:55Z ipso $
 * $Date: 2011-11-04 14:40:55 -0700 (Fri, 04 Nov 2011) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

/*
if ( !$permission->Check('accrual','view')
		OR (  $permission->Check('accrual','view_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}
*/

$smarty->assign('title', TTi18n::gettext($title = 'Apply Employee Leaves')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data',
                                                                                                'filter_data'
												) ) );


if ( isset($data)) {
	if ( $data['start_date'] != '' ) {
		$data['leave_start_date'] = TTDate::parseDateTime( $data['leave_start_date'] );
	}
	if ( $data['end_date'] != '' ) {
		$data['leave_end_date'] = TTDate::parseDateTime( $data['leave_end_date'] );
	}
}

$lrlf = TTnew( 'LeaveRequestListFactory' );

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);
		//Debug::setVerbosity(11);
            
          //  $lrf = TTnew( 'LeaveRequestFactory' );
            
            $lrf = new LeaveRequestFactory;
            
            
            $lrf->setCompany($current_company->getId());
            $lrf->setUser($current_user->getId());
            $lrf->setDesignation($data['title_id']);
            $lrf->setAccuralPolicy($data['leave_type']);
            $lrf->setLeaveMethod($data['method_type']);
            $lrf->setAmount($data['no_days']);
            
             $from_date =  DateTime::createFromFormat('j-M-y', $data['leave_start_date']);
          // $from_date =  DateTime::createFromFormat('d/m/Y', $data['leave_start_date']);
            $lrf->setLeaveFrom($from_date->format('Y-m-d'));
            
           $To_date =  DateTime::createFromFormat('j-M-y', $data['leave_end_date']);
        //  $To_date =  DateTime::createFromFormat('d/m/Y', $data['leave_end_date']);
           $lrf->setLeaveTo($To_date->format('Y-m-d'));
            
             $lrf->setReason($data['reason']);
             $lrf->setAddressTelephone($data['address_tel']);
             $lrf->setCoveredBy($data['cover_duty']);
             $lrf->setSupervisorId($data['supervisor']);
             $lrf->setCoveredApproved(1);
             $lrf->setSupervisorApproved(0);
            $lrf->setHrApproved(0);
             $lrf->setDeleted(0);
             $lrf->setStatus(10);
             
             if($data['leave_type'] == 3){
                 
                 $lrf->setCoveredApproved(1);
                 
             }

             
             
              if($data['leave_type'] == 14){
                 
                 $lrf->setCoveredApproved(1);
                 
             }
            
           // echo $data['leave_start_date'];
            $lrf->Save();
     
           break;
	default:
		
		
		break;
}
//Select box options; getName() no_days

$lrlf->getByUserIdAndCompanyId($current_user->getId(),$current_company->getId());

$leave_request = array();

if($lrlf->getRecordCount() > 0){
    
   foreach ($lrlf as $lrf) {
     
       $leave = array();
  
    
    $leave['name'] = $lrf->getUserObject()->getFullName();
    $leave['from'] = $lrf->getLeaveFrom();
    $leave['to'] = $lrf->getLeaveTo();
    $leave['amount'] = $lrf->getAmount();
    $leave['leave_type'] = $lrf->getAccuralPolicyObject()->getName();
    
     $leave['status'] = "Pending Aproovals";
    
    if($lrf->getCoveredApproved() && $lrf->getStatus()==10 ){
         $leave['status'] = "Cover Approved";
    }
    
    if (!$lrf->getCoveredApproved() && $lrf->getStatus()==20) {
        $leave['status'] = "Cover Rejected";
    
    }
    
    if($lrf->getCoveredApproved() && $lrf->getSupervisorApproved() && $lrf->getStatus()==10 ){
         $leave['status'] = "Supervisor Approved";
    }
    
    if($lrf->getCoveredApproved() && !$lrf->getSupervisorApproved() && $lrf->getStatus()==30 ){
            $leave['status'] = "Supervisor Rejected";
    }
    
    if($lrf->getCoveredApproved() && $lrf->getSupervisorApproved() && $lrf->getHrApproved() && $lrf->getStatus()==10){
         $leave['status'] = "HR Approved";
    }
    
    if($lrf->getCoveredApproved() && $lrf->getSupervisorApproved() && !$lrf->getHrApproved() && $lrf->getStatus()==40){
        $leave['status'] = "HR Rejected";
    }
    
    
    $leave_request[]= $leave;
   }
    
}



$alf = TTnew( 'AccrualListFactory' );

$aplf = TTnew( 'AccrualPolicyListFactory' );
$aplf->getByCompanyIdAndTypeId($current_company->getId(),20);

$header_leave = array();
$total_asign_leave = array();
$total_taken_leave = array();
$total_balance_leave = array();

foreach($aplf as $apf){
 
    $alf->getByCompanyIdAndUserIdAndAccrualPolicyIdAndStatus($current_company->getId(),$current_user->getId(),$apf->getId(),30);
    
    
    $header_leave[]['name']=$apf->getName();
            
    if($alf->getRecordCount() > 0)
    {
       $af= $alf->getCurrent();
       $total_asign_leave[]['asign'] =  $af->getAmount()/28800;
    }
    else{
        $total_asign_leave[]['asign'] = 0;
    }
    
    
   $ttotal =  $alf->getSumByUserIdAndAccrualPolicyId($current_user->getId(),$apf->getId());
     
    if($alf->getRecordCount() > 0)
    {
       $af= $alf->getCurrent();
       $total_taken_leave[]['taken'] =   ($af->getAmount()/28800)-($ttotal/28800);
       $total_balance_leave[]['balance'] = ($ttotal/28800);
    }
    else{
        $total_taken_leave[]['taken'] = 0;
         $total_balance_leave[]['balance'] = 0;
    }
    
}





$leave_options = array();
foreach($aplf as $apf){
    $leave_options[$apf->getId()]=$apf->getName();
    
    
    
    $alf->getByCompanyIdAndUserIdAndAccrualPolicyIdAndStatus($current_company->getId(),$current_user->getId(),$apf->getId(),30);
    
}
$leave_options = Misc::prependArray( array( 0 => TTi18n::gettext('-- Please Choose --') ), $leave_options );
$data['leave_options'] = $leave_options;
        
$method_options = $lrlf->getOptions('leave_method');
 
$method_options = Misc::prependArray( array( 0 => TTi18n::gettext('-- Please Choose --') ), $method_options );
$data['method_options'] = $method_options;
        
$ulf = TTnew( 'UserListFactory' );
//$filter_data['default_branch_id'] = $current_user->getDefaultBranch();
$filter_data['exclude_id'] = 1;

$ulf->getAPISearchByCompanyIdAndArrayCriteria( $current_company->getId(),$filter_data);
//$ulf->getAll();

$user_options = array();

foreach($ulf as $uf){
    
  $user_options[$uf->getId()] = $uf->getPunchMachineUserID().'-'.$uf->getFullName() ; 
}

$user_options = Misc::prependArray( array( 0 => TTi18n::gettext('-- Please Choose --') ), $user_options );
$data['users_cover_options'] = $user_options;
//$data['users_cover_options'] = $ulf;
$data['name'] =$current_user->getFullName();
$data['title'] = $current_user->getTitleObject()->getName();
$data['title_id'] = $current_user->getTitleObject()->getId();
$data['leave_start_date'] = '';
//$data['reason']="";

//$data['no_days'] = '';
$smarty->assign_by_ref('total_asign_leave', $total_asign_leave);
$smarty->assign_by_ref('total_taken_leave', $total_taken_leave);
$smarty->assign_by_ref('total_balance_leave', $total_balance_leave);
$smarty->assign_by_ref('header_leave', $header_leave);



$smarty->assign_by_ref('leave_request', $leave_request);
$smarty->assign_by_ref('data', $data);
$smarty->assign_by_ref('user', $current_user);

//$current_user->getId() 

$smarty->display('leaves/ApplyUserLeave.tpl');

?>